// JavaScript Document


//DEBUG VARS TURN OFF!!!!!!!!!!!
var DEBUG_ShowAdvertisement  = false;
var DEBUG_ConnectMobileInternet= false;


var activeConnectionTab = "";

var InternetAvailableMobile = false;
var InternetAvailableWiFi = false;
var InternetAvailableEthernet = false;

var mobileInfoTimeout;

var currentAdvertismentUrl = "";
var currentAdvertismentImageUrl = "";
var currentAdvertismentId = "";

var mobileInfo;
var mobileInfoState;

//"MobileTab"
//"WiFiTab"
//"EthernetTab"


// CODE TO REMOVE CURSOR SELECTION AND IMAGE DRAG
//window.onload += function(e)
function doOnLoad()
{
	console.log("Dialler.js-doOnLoad()");
	
	Mobile_Clicked();
	
	/*var evt = e || window.event,
	// define event (cross browser)
	imgs, a, // images collection
	i; // used in local loop
	// if preventDefault exists, then define onmousedown event handlers
	if (evt.preventDefault)
	{
		// collect all images on the page
		imgs = document.getElementsByTagName('img');
		a = document.getElementsByTagName('a');
		
		// loop through fetched images
		for (i = 0; i < imgs.length; i++)
		{
			// and define onmousedown event handler
			imgs[i].onmousedown = disableDragging;
		}
		for (i = 0; i < a.length; i++)
		{
			// and define onmousedown event handler
			a[i].onmousedown = disableDragging;
		}
	}*/

	// Order is important here. Do Mobile last
	// (atm it will much up "autoconnect" feature otherwise)
	Ethernet_UpdateInfo();
	WiFi_UpdateInfo();
	Mobile_UpdateInfo();
	Messages_UpdateInfo();
	
	if(CefRunning())
	{
		// This function conflicts with the onload in trans-function for some reason,
		// so I have added this here (Rhys). Might want to investigate why this happening
		// and come up with a better solution	
		//language = cef.application.GetLanguage();
		//translate();	

		window.cefWindow.SetWindowPos(0, 100, 100, 287, 390, SWP_NOZORDER);
		window.cefWindow.CenterWindow();
		
		Mobile_Clicked();
		
		window.cefWindow.ShowWindow(true);
	}
	else
	{
		
	}
	
	setTimeout("Mobile_UpdateInfo_Timer()", 30000);
};

function Mobile_UpdateInfo_Timer()
{
	if(CefRunning())
		window.cefWindow.OutputDebugString("Mobile_UpdateInfo_Timer();");
	Mobile_UpdateInfo();
}

function sivamtime()
{
	now = new Date();
	hour = now.getHours();
	min = now.getMinutes();
	sec = now.getSeconds();

	if (min <= 9) {
		min = "0" + min;
	}
	if (sec <= 9) {
		sec = "0" + sec;
	}
	if (hour > 12) {
		hour = hour - 12;
		add = "pm";
	}
	else {
		hour = hour;
		add = "am";
	}
	if (hour == 12) {
		add = "pm";
	}

	var newVal = ((hour <= 9) ? "0" + hour : hour) + ":" + min + ":" + sec + " " + add;
	SetLine1(newVal);

	setTimeout("sivamtime()", 1000);
}


function UpdateLanguage()
{
	translate(language);
}

function UpdateLanguage(newlanguage)
{
	language = newlanguage;
	translate(language);
}

function disableDragging(e)
{
	e.preventDefault();
}



// Called by cefWindow when focus is on

/////////////////////
// Focus Functions //
// Not currently used
function FocusOn()
{
	//window.cefWindow.OutputDebugString("Dialler-FocusOn");
}

function FocusOff()
{
	//window.cefWindow.OutputDebugString("Dialler-FocusOff");
}
/////////////////
/////////////////////////////
// Title Bar Button Clicks //

function Drag_Clicked()
{
	window.cefWindow.Drag();
}

function Minimised_Clicked()
{
	cef.application.ShowNovusWindow("ConnectionManager", SW_SHOWMINIMIZED);
}

function Exit_Clicked()
{
	cef.application.CloseNovusWindow("ConnectionManager");
}
/////////////////////////////


//////////////////////////////////////////

function ShowEnterPin()
{			
	 $('#UserPin').show(0, onDivShow);
}


function onDivShow()
{
	$("#UserPin").focus();

 }
   

	
 $(function() {
    $("#UserPin").keypress(function (e) {
		 if($("#UserPin").is(":visible")){
        if ((e.which && e.which == 13) || (e.keyCode && e.keyCode == 13)) {
            $('#ConnectButton').click();
			//alert('Enter Pressed');
            return false;
        } else {
            return true;
        }
		}
    });
	
	
});



function ShowEnterPuk(inTries)
{	
	if(cef.application)
	{
		cef.application.OpenNovusWindow(NovusWindowId_PUKDialog);
	}	
}

function HideEnterPinPuk()
{
	$('#UserPin').hide();
}

function PinPukButton_Click()
{
	HideEnterPinPuk();
	if(cef.application && cef.mobile)
	{	
		var pin = $('#UserPin').val();
		var puk = $('#UserPuk').val();
		
		cef.mobile.EnterPinPuk(pin, puk);
	}
	$('#UserPin').val("");
	$('#UserPuk').val("");
}
//////////////////////////////////////////


//////////////////////////////////
// Connection Bar Button Clicks //

function Mobile_Clicked()
{
	if (activeConnectionTab == "MobileTab")
		return;
		
	//Dont want to reload tabs if already selected as buttons may be disabled etc.
	hideWiFiList();
	//Services Button Clicked
	ActiveConnectionTabState("MobileTab");
	document.getElementById("ContentButton").style.visibility = "visible";

	Mobile_UpdateInfo();
}

function WiFi_Clicked()
{
	if (activeConnectionTab == "WiFiTab")
		return;
		
	//Dont want to reload tabs if already selected as buttons may be disabled etc.
	HideEnterPinPuk();
	ActiveConnectionTabState("WiFiTab");
	WiFi_UpdateInfo();


}


function Ethernet_Clicked() {
	
	if (activeConnectionTab == "EthernetTab")
		return;
	
	HideEnterPinPuk();
	hideWiFiList();
	
	ActiveConnectionTabState("EthernetTab");
	document.getElementById("ContentButton").style.visibility = "hidden";

	Ethernet_UpdateInfo();

}

function PrepaidTopup_Clicked()
{
	if (CefRunning())
		cef.application.LaunchURLCode("Prepaid");	
}

//////////////////////////////////

////////////////////////////
// *_UpdateInfo Functions //

function Messages_UpdateInfo()
{
	var newMessages = 0;
	
	if(CefRunning())
	{
		var messageInfo = cef.messages.GetInfo();
		if(messageInfo)
			newMessages = messageInfo.UnreadMessages;
	}
	
	setNewMessageBadge(newMessages);
}

if (typeof String.prototype.startsWith != 'function')
{
	String.prototype.startsWith = function (str){
		return this.indexOf(str) == 0;
	};
}

function IsCustomerPrepaid(mobileInfo)
{
	if(CefRunning())
	{
		window.cefWindow.OutputDebugString(mobileInfo.simStatus.imsi);

		if(mobileInfo.simStatus.imsi.startsWith("24412131")
			|| mobileInfo.simStatus.imsi.startsWith("24008") //Debug: To Delete
			)
			return true;
	}
		
	return false;
}

function ShowPrepaidButton(showPrepaid)
{
	if(showPrepaid){
		$('#PrepaidButton').show(); 
	}else{
		$('#PrepaidButton').hide(); 	
	}
	
}

function Mobile_UpdateInfo() 
{
	//window.cefWindow.OutputDebugString("Mobile_UpdateInfo Start");
	
	HideEnterPinPuk();
	
	//UpdateAdvertisment();
	
	var line1Text = "";
	var line2Text = "";
	var line3Text = "";
	var showButton = true;
	
	var contentButtonText = "";
	var newMobileTabNetworkType = "";

	var mobileConnected = false;
	var deviceAvailable = false;
	var networkAvailable = false;
	
	var InternetAvailableMobileTemp = false;
	var signalQualitydBm = 0;
	var signalQualityEcio = 0;
	var signalQualityRscp = 0;
	
	var showEnterPIN = false;
	var showPrepaid = false;
	
	
	var enableButton = true;
	var buttonStyle = 'Standard';
	
	
	

	if (CefRunning())
	{
		mobileInfo = cef.mobile.GetInfo();
		mobileInfoState = GetMobileState(mobileInfo);

		//window.cefWindow.OutputDebugString("Mobile_UpdateInfo: cef.application && cef.mobile");
		// DEBUG  mobileInfoState = MobileStateEnterPin;

		line2Text = GetMobileNetworkTypeText(mobileInfo.networkRegistration.networkCap);
		
		signalQualitydBm = mobileInfo.signalQuality.signalQualitydBm;
		signalQualityEcio = mobileInfo.signalQuality.signalEcNo;
		signalQualityRscp = mobileInfo.signalQuality.signalRscp;
		
		switch (mobileInfoState) {
		case MobileStateNoDevice:
			enableButton = true;
			line1Text = getTrans('MobileState.NoDevice');
			contentButtonText = "General.HelpButtonText";
			break;

		case MobileStateDeviceConnecting:
			enableButton = false;
			line1Text = getTrans('MobileState.DeviceConnecting');
			contentButtonText = "General.ConnectButtonText";
			buttonStyle = 'Connect';
			break;
		case MobileStateDeviceInUse:
			enableButton = true;
			deviceAvailable = true;
			line1Text = getTrans('MobileState.DeviceInUse');
			contentButtonText = "General.HelpButtonText";
			break;
		case MobileStateNoSim:
			enableButton = true;
			deviceAvailable = true;
			line1Text = getTrans('MobileState.NoSim'); 
			contentButtonText = "General.HelpButtonText";
			break;
		case MobileStateUnsupportedSim:
			enableButton = false;
			deviceAvailable = true;
			line1Text = getTrans('MobileState.UnsupportedSim'); 
			contentButtonText = "General.ConnectButtonText";		
			break;
		case MobileStateEnterPin:
			enableButton = true;
			deviceAvailable = true;
			line1Text =  getTrans('MobileState.PINCodeRequired');
			line2Text = sprintf(translations.General.TriesRemaining[language], mobileInfo.simStatus.pinTriesRemaining);
			contentButtonText = "General.EnterPinButtonText";
			
			showEnterPIN = true;
			break;

		case MobileStateEnterPuk:
			enableButton = true;
			deviceAvailable = true;
			line1Text = getTrans('MobileState.PUKCodeRequired');
			line2Text = sprintf(translations.General.TriesRemaining[language], mobileInfo.simStatus.pukTriesRemaining);
			contentButtonText = "General.EnterPukButtonText";
			break;

		case MobileStateEnteringPinPuk:
			enableButton = false;
			deviceAvailable = true;
			line1Text = getTrans('MobileState.EnteringPinPuk');
			contentButtonText = "General.ConnectButtonText";
			buttonStyle = 'Connect';
			break;

		case MobileStateNoNetwork:
			enableButton = true;
			deviceAvailable = true;
			line1Text = getTrans('MobileState.NoNetwork');
			contentButtonText = "General.HelpButtonText";
			break;

		case MobileStateNetworkDenied:
			enableButton = true;
			deviceAvailable = true;
			line1Text = getTrans('MobileState.NetworkDenied');
			contentButtonText = "General.HelpButtonText";
			break;

		case MobileStateNetworkNotRegistered:
			enableButton = true;
			deviceAvailable = true;
			line1Text =  getTrans('MobileState.NetworkNotRegistered');
			contentButtonText = "General.HelpButtonText";
			break;

		case MobileStateNetworkSearching:
			enableButton = false;
			deviceAvailable = true;
			line1Text = getTrans('MobileState.NetworkSearching');
			contentButtonText = "General.ConnectButtonText";
			buttonStyle = 'Connect';
			break;

		case MobileStateInternetConnected:
		
		//show add.. 
		//setAdvertisement('images/Advert.png','http://www.dna.fi/verkkokauppa/puhelinjaliittyma/Sivut/Default.aspx?AgreementLength=24');
		//UpdateAdvertisment();
		
			mobileConnected = true;
			enableButton = true;
			deviceAvailable = true;
			networkAvailable = true;
			line1Text = mobileInfo.networkRegistration.networkName;
			if(mobileInfo.networkRegistration.registrationStatus == MobileRegistrationStatusRoaming)
				line2Text += " (" + getTrans("General.RoamingNetwork") + ")";			
			line3Text = getTrans('MobileState.InternetConnected'); 
			contentButtonText = "General.DisconnectButtonText";
			buttonStyle = 'Disconnect';
			InternetAvailableMobileTemp = true;
			showPrepaid = IsCustomerPrepaid(mobileInfo);
			break;

		case MobileStateInternetConnecting:
			enableButton = false;
			deviceAvailable = true;
			networkAvailable = true;	
			line1Text = mobileInfo.networkRegistration.networkName;
			if(mobileInfo.networkRegistration.registrationStatus == MobileRegistrationStatusRoaming)
				line2Text += " (" + getTrans("General.RoamingNetwork") + ")";		
			line3Text =  getTrans('MobileState.InternetConnecting'); 
			contentButtonText = "General.DisconnectButtonText";
			buttonStyle = 'Connect';
			break;

		case MobileStateInternetDisconnecting:
		
		removeAdvertisement();
		
			enableButton = false;
			deviceAvailable = true;
			networkAvailable = true;	
			line1Text = mobileInfo.networkRegistration.networkName;
			if(mobileInfo.networkRegistration.registrationStatus == MobileRegistrationStatusRoaming)
				line2Text += " (" + getTrans("General.RoamingNetwork") + ")";	
			line3Text = getTrans('MobileState.InternetDisconnecting');
			contentButtonText = "General.ConnectButtonText";
			buttonStyle = 'Disconnect';
			break;

		case MobileStateReady:
			enableButton = true;
			deviceAvailable = true;
			networkAvailable = true;
			line1Text = mobileInfo.networkRegistration.networkName;
			if(mobileInfo.networkRegistration.registrationStatus == MobileRegistrationStatusRoaming)
			{
				line2Text += " (" + getTrans("General.RoamingNetwork") + ")";
			}
			line3Text = getTrans('MobileState.Disconnected');
			contentButtonText = "General.ConnectButtonText";
			buttonStyle = 'Connect';
			break;

		case MobileStateServiceUnavailable:
			//enableButton = false;
			line1Text = "Mobile service unavailable";
			contentButtonText = "General.EnableService";
			break;

		case MobileStateUnknown:
		case NaN:
		default:
			enableButton = false;
			line1Text = getTrans('MobileState.Unknown');
			break;
		}


		if(DEBUG_ConnectMobileInternet) //Make 1 to turn on
		{
			mobileInfoState	= MobileStateInternetConnected;
		
			mobileConnected = true;
			enableButton = false;
			deviceAvailable = true;
			networkAvailable = true;
			line1Text = "Fake Network name (DEBUG)";
			if(0)
				line2Text += " (" + getTrans("General.RoamingNetwork") + ")";			
			line3Text = getTrans('MobileState.InternetConnected'); 
			contentButtonText = "General.DisconnectButtonText";
			InternetAvailableMobileTemp = true;
			showPrepaid = false;//
		}

		if(mobileInfo.ManagedConnection)
		{
			if(mobileInfoState == MobileStateReady
				|| mobileInfoState == MobileStateInternetDisconnecting
				|| mobileInfoState == MobileStateInternetConnecting
				|| mobileInfoState == MobileStateInternetConnected)
			{
				enableButton = false;
				contentButtonText = "General.ManagedConnection";
				buttonStyle = 'Disconnect';
			}
				
			if(line2Text == undefined || line2Text == "")
				line2Text = "&nbsp;";
			//line3Text = getTrans("General.ManagedConnection");
		}

		//window.cefWindow.OutputDebugString("Mobile_UpdateInfo: activeConnectionTab=" + activeConnectionTab);
		
		SetMobileStrength(mobileInfo.signalQuality.signalStrength,
			mobileInfo.networkRegistration.networkCap,
			mobileConnected,
			deviceAvailable,
			networkAvailable);
		
		if (activeConnectionTab == "MobileTab")
		{
			SetLine1(line1Text);
			SetLine2(line2Text);
			SetLine3(line3Text);
				
			if(showButton)
			{
				document.getElementById("ContentButton").style.visibility = "visible";
				
				enableMainButton(enableButton);
				translateUpdateItem(language, "ContentButtonText", contentButtonText);
				translateUpdateItem(language, "ContentButtonText", contentButtonText);	
				setMainButtonStyle(buttonStyle);		
			}
			else
				document.getElementById("ContentButton").style.visibility = "hidden";
			
			ShowPrepaidButton(showPrepaid);
			
			if(showEnterPIN)
				ShowEnterPin();	
		}
		
		 //Set signal bar tooltip
		var tooltipText = '';
		if(line1Text != ''){
			tooltipText += line1Text;
		}
		if(line2Text != ''){
			tooltipText += '\r\n'+line2Text;
		}
		if(line3Text != ''){
			tooltipText += '\r\n'+line3Text;
		}
		
		if(signalQualitydBm != 0)
			tooltipText += '\r\nSignal: '+signalQualitydBm+'dBm';
		//if(signalQualityEcio != 0)
		//	tooltipText += '\r\nEc/No: '+signalQualityEcio+'dBm';
		//if(signalQualityRscp != 0)
		//	tooltipText += '\r\nRSCP: '+signalQualityRscp+'dBm';
			
		$('#MobileSignal').attr('title',tooltipText);
		
		

		
		

	}
	else
	{
		// Non-CEF Handling
		SetLine1('Network Name');
		SetLine2('Mobile Connection status');
		SetLine3('Usage');
		SetMobileStrength(5, MobileNetCapUnknown, true, true, true); 
		setMainButtonStyle(buttonStyle, enableButton);
		enableMainButton(false)
	}
	
	InternetAvailableMobile = InternetAvailableMobileTemp;
	
	UpdateAdvertisment();
	
	SetButtonStatusOnInternet();

	clearTimeout(mobileInfoTimeout);	
	mobileInfoTimeout = setTimeout("Mobile_UpdateInfo_Timer()", 30000);	
}

function SetButtonStatusOnInternet()
{
	if(InternetAvailableMobile || InternetAvailableWiFi || InternetAvailableEthernet)
		enableButton('Jump_Services');
	else
		disableButton('Jump_Services');
		
	//Temporary - should tie this into internet avaialble above? Lets discuss.
	enableButton('Jump_Help');
}

function WiFi_UpdateInfo()
{
	var line1Text = "";	
	var line2Text = "";
	var line3Text = "";
	var showButton = false;
	var signalStrength = 0;
	var contentButtonText = "";
	var deviceAvailable = false;
	var deviceConnected = false;
	var physicalType = 0;
	var InternetAvailableWiFiTemp = false;
	var buttonStyle = 'Standard';
		
		
	if (CefRunning())
	{
		var wirelessInfo = cef.wireless.GetInfo();
			
		if(wirelessInfo == undefined)
		{
			line1Text = getTrans('EthernetState.NoAdapterDetected');
		}
		else if(!wirelessInfo.Wlan.RadioEnabled)
		{
			line1Text = getTrans('Wireless.HardwareRadioDisabled');
		}
		else
		{
			deviceAvailable = true;		
			switch (wirelessInfo.AdapterState)
			{
			case EthernetStateDisconnected:
			case EthernetStateMediaDisconnected:
				showButton = true;
				contentButtonText = "General.ViewNetworks";

				line1Text = getTrans('EthernetState.Disconnected');
				line2Text = sprintf(translations.Wireless.AvailableNetworks[language], wirelessInfo.Wlan.NumberOfAvailableNetworks); //wirelessInfo.Wlan.NumberOfAvailableNetworks + " "+ getTrans('Wireless.AvailableNetworks');
				break;
			case EthernetStateConnecting:
				contentButtonText = "General.ConnectButtonText";
				enableMainButton(false);
				buttonStyle = 'Connect';
				if(wirelessInfo.Wlan)
					signalStrength = GetWLanSigBarsFromPerc(wirelessInfo.Wlan.CurrentConnection.SignalQuality);
					line1Text = getTrans('EthernetState.Connecting'); 
				break;
			case EthernetStateConnected:
			
			
			
			
				InternetAvailableWiFiTemp = true;
				if(wirelessInfo.Wlan.CurrentConnection)
				{
					physicalType = wirelessInfo.Wlan.CurrentConnection.PhysicalType;
					deviceConnected = true;
					showButton = true;
					contentButtonText = "General.DisconnectButtonText";
					buttonStyle = 'Disconnect';
					signalStrength = GetWLanSigBarsFromPerc(wirelessInfo.Wlan.CurrentConnection.SignalQuality);
					line1Text = wirelessInfo.Wlan.CurrentConnection.Ssid;
					line2Text = getTrans('Wireless.Encryption') + ": " + WirelessSecurityString(wirelessInfo.Wlan.CurrentConnection.SecurityAuthAlgorithm, wirelessInfo.Wlan.CurrentConnection.SecurityCipherAlgorithm);
					line3Text = getTrans('EthernetState.Connected'); 
				}
				break;
			case EthernetStateDisconnecting:
				contentButtonText = "General.DisconnectButtonText";
				buttonStyle = 'Disconnect';
				enableMainButton(false);
				if(wirelessInfo.Wlan)
					signalStrength = GetWLanSigBarsFromPerc(wirelessInfo.Wlan.CurrentConnection.SignalQuality);
					line1Text = getTrans('EthernetState.Disconnecting');
				break;
			case EthernetStateUnavailable:
				showButton = true;
				contentButtonText = "General.ManageWiFi";
				line1Text = ""; //"Unavailable on 10.5";
				break;				
			case NaN:
			default:
				line1Text = getTrans('EthernetState.Unknown');
				break;
			}
		}

		SetWiFiStrength(signalStrength, deviceConnected, physicalType, deviceAvailable);
		
		if(activeConnectionTab == "WiFiTab")
		{
			SetLine1(line1Text);
			SetLine2(line2Text);
			SetLine3(line3Text);
			
			if(showButton)
			{
				//dont update the connect button if we are wifi list view..
				if(!wifiListExpanded){
					translateUpdateItem(language, "ContentButtonText", contentButtonText);
					setMainButtonStyle(buttonStyle);
					document.getElementById("ContentButton").style.visibility = "visible";
					enableMainButton(true);
					
				}
			}
			else
				document.getElementById("ContentButton").style.visibility = "hidden";
				
			ShowPrepaidButton(false);
		}
	}
	else
	{
		// Non-CEF Handling
		SetLine1('Network Name');
		SetLine2('WiFi Connection status');
		SetLine3('');

		SetWiFiStrength(GetWLanSigBarsFromPerc(20));
	}

	//Set signal bar tooltip
	var tooltipText = '';
	if(line1Text != ''){
		tooltipText += line1Text;
	}
	if(line2Text != ''){
		tooltipText += '\r\n'+line2Text;
	}
	if(line3Text != ''){
		tooltipText += '\r\n'+line3Text;
	}
	//tooltipText += '\r\nSignal: '+GetWLanSigBarsFromPerc(20)+' bars';
	  $('#WifiSignal').attr('title',tooltipText);
	  
	InternetAvailableWiFi = InternetAvailableWiFiTemp;
	SetButtonStatusOnInternet();
}


function Ethernet_UpdateInfo()
{
	//if(window.cefWindow)
	//	window.cefWindow.OutputDebugString("Ethernet_UpdateInfo");

	EthernetConnected = false;
	var line1Text = "";
	var line2Text = "";
	var line3Text = "";
	var signalStrength = 0;	
	var InternetAvailableEthernetTemp = false;
		
	if (CefRunning())
	{
		var ethernetInfo = cef.ethernet.GetInfo();
			
		if(ethernetInfo == undefined)
		{
			SetLine1(getTrans('EthernetState.NoAdapterDetected'));
		}
		else
		{
			switch (ethernetInfo.AdapterState)
			{
			case EthernetStateDisconnected:
			case EthernetStateMediaDisconnected:
				signalStrength = 0;
				line1Text = getTrans('EthernetState.Disconnected');
				break;
			case EthernetStateConnecting:
				signalStrength = 5;
				line1Text = getTrans('EthernetState.Connecting');
				break;
			case EthernetStateConnected:
			
				InternetAvailableEthernetTemp = true;
				signalStrength = 5;
				line1Text = getTrans('EthernetState.Connected');
				EthernetConnected = true;
				break;
			case EthernetStateDisconnecting:
				signalStrength = 5;
				line1Text = getTrans('EthernetState.Disconnecting');
				break;
			case NaN:
			default:
				signalStrength = 0;
				line1Text =  getTrans('EthernetState.Unknown');
				break;
			}
		}

		if(ethernetInfo != undefined)
			SetEthernetStrength(signalStrength, ethernetInfo.AdapterState);
		
		if(activeConnectionTab == "EthernetTab")
		{
			SetLine1(line1Text);
			SetLine2(line2Text);
			SetLine3(line3Text);
			
			ShowPrepaidButton(false);
		}
	}
	else
	{
		// Non-CEF Handling
		SetLine1('Network Name');
		SetLine2('Ethernet Connection status');
		SetLine3('');
	}		
	
	//Set signal bar tooltip
	var tooltipText = '';
	if(line1Text != ''){
		tooltipText += line1Text;
	}
	if(line2Text != ''){
		tooltipText += '\r\n'+line2Text;
	}
	if(line3Text != ''){
		tooltipText += '\r\n'+line3Text;
	}
	
	$('#EthernetSignal').attr('title',tooltipText);
	
	InternetAvailableEthernet = InternetAvailableEthernetTemp;
	SetButtonStatusOnInternet();
}


// Connect Button Click
// Depending on the context (activeConnectionTab), will behave differently
function ConnectButton_Click()
{
	if(activeConnectionTab == "MobileTab")
	{
		if (cef.application && cef.mobile)
		{
			//var mobileInfo = cef.mobile.GetInfo();
			//var mobileInfoState = GetMobileState(mobileInfo);

			switch (mobileInfoState) {
			case MobileStateNoDevice:
				OpenHelpWindow('NoDevice');
				break;

			case MobileStateDeviceConnecting:

				break;

			case MobileStateDeviceInUse:
				OpenHelpWindow('DeviceInUse');
				break;

			case MobileStateNoSim:
				OpenHelpWindow('NoSim');
				break;

			case MobileStateEnterPin:
				//cef.mobile.EnterPinPuk();
				//ShowEnterPin();
				PinPukButton_Click()
				break;

			case MobileStateEnterPuk:
				//cef.mobile.EnterPinPuk();
				ShowEnterPuk(mobileInfo.simStatus.pukTriesRemaining);
				break;

			case MobileStateEnteringPinPuk:

				break;

			case MobileStateNoNetwork:
				OpenHelpWindow('NoNetwork');
				break;

			case MobileStateNetworkDenied:
				OpenHelpWindow('NetworkDenied');
				break;

			case MobileStateNetworkNotRegistered:
				OpenHelpWindow('NotRegistered');
				break;

			case MobileStateNetworkSearching:
				cef.application.IncrimentUsage("Dialler.Mobile.Connect");
				enableMainButton(false);
				cef.mobile.Connect();
				break;

			case MobileStateInternetConnected:
				cef.application.IncrimentUsage("Dialler.Mobile.Disconnect");
				enableMainButton(false);
				cef.mobile.Disconnect();
				break;

			case MobileStateInternetConnecting:

				break;

			case MobileStateInternetDisconnecting:

				break;

			case MobileStateReady:
				if(mobileInfo.networkRegistration.registrationStatus == MobileRegistrationStatusRoaming && !cef.mobile.IsRoamingAllowed())			
					cef.application.OpenNovusWindow(NovusWindowId_NoRoamingAllowedWindow);
				else if(mobileInfo.networkRegistration.registrationStatus == MobileRegistrationStatusRoaming)
					cef.application.OpenNovusWindow(NovusWindowId_RoamingDialog);
				else
				{
					cef.application.IncrimentUsage("Dialler.Mobile.Connect");
					enableMainButton(false);
					cef.mobile.Connect();
				}
					
				break;
				
			case MobileStateServiceUnavailable:
			
				cef.application.IncrimentUsage("Dialler.Mobile.EnableService");
				cef.mobile.EnableService();
			
				break;

			case MobileStateUnknown:
			case NaN:
			default:
				break;
			}
		}
		else
		{
			SetLine3("clicked button!");	
		}
	}
	else if(activeConnectionTab == "WiFiTab")
	{
		if (cef.application && cef.wireless) {
			var wirelessInfo = cef.wireless.GetInfo();

			switch (Number(wirelessInfo.AdapterState))
			{
			case EthernetStateDisconnected:
			case EthernetStateMediaDisconnected:
				if (wifiListExpanded)
				{
					ConnectWiFi();
				}
				else
				{
					expandWiFiList();
				}
				//!!!!cef.wireless.LaunchWindowsWirelessNetworkConnect();
				break;
			case EthernetStateConnected:
				enableMainButton(false);
				cef.application.IncrimentUsage("Dialler.Wireless.Disconnect");
				cef.wireless.Disconnect();
				break;
			case EthernetStateUnavailable:
				// SOmething here Karl? Perhaps we need a func like:
				// cef.wireless.LaunchWirelessNetworkConnect();
			break
			}
		}
		else
		{
			SetLine3("clicked button!");	
		}	
	}
}

//////////////////////////////
// Misc. & Helper Functions //

// Link Bar button clicks
function Link_Services_Clicked()
{
	if (CefRunning())
	{
		cef.application.IncrimentUsage("Dialler.Services");
		cef.application.OpenNovusWindow(NovusWindowId_ServicesWindow);
	}
}

function Link_Messages_Clicked()
{
	if (CefRunning())
	{
		cef.application.IncrimentUsage("Dialler.Messages");
		cef.application.OpenNovusWindow(NovusWindowId_MessagesWindow);
	}
}

function Link_Help_Clicked()
{
	//DEBUG removeAdvertisement();
	cef.application.IncrimentUsage("Dialler.Help");
	OpenHelpWindow('');
}

function Link_Settings_Clicked()
{
	//DEBUG setAdvertisement('images/Advert.png','http://www.emotum.com');	
	if (CefRunning())
	{
		cef.application.IncrimentUsage("Dialler.Settings");
		cef.application.OpenNovusWindow(NovusWindowId_SettingsWindow);
	}
}


// SetLine Functions
function SetLine1(txt)
{
	document.getElementById("Line1").innerHTML = txt;
}
function SetLine2(txt)
{
	document.getElementById("Line2").innerHTML = txt;
}
function SetLine3(txt)
{
	document.getElementById("Line3").innerHTML = txt;
}


// Set Signal Strength Funcs
function SetMobileStrength(num, type, pdpConnected, deviceAvailable, networkAvailable)
{
	var connectionType = "2G";
	if(type == MobileNetCapHSPAPlus
		|| type == MobileNetCapTDSCDMA
		|| type == MobileNetCapHSDPAHSUPA
		|| type == MobileNetCapHSUPA
		|| type == MobileNetCapHSDPA
		|| type == MobileNetCapHSPA
		|| type == MobileNetCapUMTS)
		connectionType = "3G";
	else if(type == MobileNetCapEGPRS
		|| type == MobileNetCapGPRS
		|| type == MobileNetCapGSM)
		connectionType = "2G";
	//else
	//	connectionType = "Unk";

	//var connected = MobileConnected;
	
	if (num == -1)
	{
		num = 'Off';
	}
	else if (num > 5)
	{
		num = 5;
	}
	

	//Set signal bars icon and badge.
	var signalIconCSS = '';
	var badgeIconCSS = '';
	if(!deviceAvailable)
	{
		signalIconCSS = 'MobileUnavailable';
		badgeIconCSS = 'none'
	}	
	else if(!networkAvailable)
	{
		signalIconCSS = 'MobileUnavailable';
		badgeIconCSS = 'none'
	}
		else if(pdpConnected)
	{
		signalIconCSS = 'MobileConnected_'+num;
		
		if(connectionType == "3G")
		{
		badgeIconCSS = 'Badge_3GConnected'
		}
		else
		{
		badgeIconCSS = 'Badge_2GConnected'
		}
	}
	else
	{
		signalIconCSS = 'Mobile_'+num;
		
		if(connectionType == "3G")
		{
			badgeIconCSS = 'Badge_3G'
		}
		else
		{
			badgeIconCSS = 'Badge_2G'
		}
	}
	
	//Set bars..
	$("#MobileSignal").attr('icon',signalIconCSS);
	$("#MobileBadge").attr('icon',badgeIconCSS);

}

function GetMobileNetworkTypeText(type)
{
	var typeText = "";
	
	switch(type)
	{
	case MobileNetCapHSPAPlus:
		typeText = "3G (HSPA+)";
		break;
	case MobileNetCapTDSCDMA:
		typeText = "3G (TDSCDMA)";
		break;
	case MobileNetCapHSDPAHSUPA:
		typeText = "3G (HSDPA/HSUPA)";
		break;
	case MobileNetCapHSUPA:
		typeText = "3G (HSUPA)";
		break;
	case MobileNetCapHSDPA:
		typeText = "3G (HSDPA)";
		break;
	case MobileNetCapHSPA:
		typeText = "3G (HSPA)";
		break;
	case MobileNetCapUMTS:
		typeText = "3G (UMTS)";
		break;
	case MobileNetCapEGPRS:
		typeText = "2G (EDGE)";
		break;
	case MobileNetCapGPRS:
		typeText = "2G (GPRS)";
		break;
	case MobileNetCapGSM:
		typeText = "2G (GPRS)";
		break;
	default:
		typeText = "";
		break;
	}

	return typeText;
}

function SetWiFiStrength(num, wifiConnected, physicalConnectionType, deviceAvailable)
{	
	//window.cefWindow.OutputDebugString("num=" + num + " wifiConnected=" + wifiConnected + "physicalConnectionType=" + physicalConnectionType + " deviceAvailable=" + deviceAvailable);

	if (num == -1)
	{
		num = 'Off';
	}
	else if (num > 4)
	{
		num = 4;
	}
	
	var connectionType = "";
	if(physicalConnectionType == WlanPhyTypeA)
		connectionType = "A";
	else if(physicalConnectionType == WlanPhyTypeB)
		connectionType = "B";
	else if(physicalConnectionType == WlanPhyTypeG)
		connectionType = "G";
	else if(physicalConnectionType == WlanPhyTypeN)
		connectionType = "N";
		
		
		
	//Set signal bars icon and badge.
	var signalIconCSS = '';
	var badgeIconCSS = '';
	if(!deviceAvailable)
	{
		signalIconCSS = 'WiFiUnavailable';
		badgeIconCSS = 'none'
	}	
	else if(wifiConnected)
	{
		signalIconCSS = 'WiFiConnected_'+num;
		badgeIconCSS = 'Badge_'+connectionType;
	}
	else
	{
		signalIconCSS = 'WiFiAvailable';
		badgeIconCSS = 'none'
	}
	
	//Set bars..
	$("#WifiSignal").attr('icon',signalIconCSS);
	$("#WifiBadge").attr('icon',badgeIconCSS);
	
}

function SetEthernetStrength(num, state)
{
	//var connected = EthernetConnected;
		
	if (num == -1)
	{
		num = 'Off';	
	}
	else if (num > 1)
	{
		num = 1;
	}


	//Set Ethernet Signal Icon
		var signalIconCSS = "";
	if(state == EthernetStateMediaDisconnected)
		signalIconCSS = "EthernetAvailable";
	else if(state == EthernetStateConnected)
		signalIconCSS = "EthernetConnected"; 
	else  //Device Disabled/Not Present/Some other weird state
		signalIconCSS = "EthernetUnavailable";
		
	//Apply icon style
	$("#EthernetSignal").attr('icon',signalIconCSS);
	
}



// Set the active connection tab state
function ActiveConnectionTabState(id)
{
	activeConnectionTab = id;

	//Sets visual state of activated tab
	if(id == "MobileTab")
	{
		
		document.getElementById("MobileTab").setAttribute("class", "ActiveConnectionTabTL");
		document.getElementById("WiFiTab").setAttribute("class", "ConnectionTabC");
		document.getElementById("EthernetTab").setAttribute("class", "ConnectionTabTR");
		
		//Remove tabbing for selected tab.
		$('#MobileTab a').removeAttr("href");
		$('#WiFiTab a').attr("href","");
		$('#EthernetTab a').attr("href","");
	}
	else if(id == "WiFiTab")
	{
		document.getElementById("MobileTab").setAttribute("class", "ConnectionTabTL");
		document.getElementById("WiFiTab").setAttribute("class", "ActiveConnectionTabC");
		document.getElementById("EthernetTab").setAttribute("class", "ConnectionTabTR");
		
		//Remove tabbing for selected tab.
		$('#WiFiTab a').removeAttr("href");
		$('#MobileTab a').attr("href","");
		$('#EthernetTab a').attr("href","");
	}
	else if(id == "EthernetTab")
	{
		document.getElementById("MobileTab").setAttribute("class", "ConnectionTabTL");
		document.getElementById("WiFiTab").setAttribute("class", "ConnectionTabC");
		document.getElementById("EthernetTab").setAttribute("class", "ActiveConnectionTabTR");
		
		//Remove tabbing for selected tab.
		$('#EthernetTab a').removeAttr("href");
		$('#MobileTab a').attr("href","");
		$('#WiFiTab a').attr("href","");
	}
}



//Set New Messages Badge on Messages Icon..
function setNewMessageBadge(val)
{
	if(val>0)
	{
		$('#NewMessagesBadge').show();
		$('#NewMessagesBadge').text(val)
	}
	else
	{
		$('#NewMessagesBadge').hide(); 
	}
}


function disableButton(buttonID)
{
	$('#'+buttonID).attr('disabled','disabled');
}
function enableButton(buttonID)
{
	$('#'+buttonID).attr('disabled','');
}

// Enable/Disable main button (active or greyed out)
function enableMainButton(val)
{
	if(val == false)
	{
		//$('#ConnectButton').removeClass('MainButton');
		//$('#ConnectButton').addClass('MainButtonDisabled');
		//$("#ConnectButton").attr('disabled','disabled');
		
		disableButton('ConnectButton');
	}
	else
	{
		//$('#ConnectButton').removeClass('MainButtonDisabled');
	//	$('#ConnectButton').addClass('MainButton');
		//$("#ConnectButton").attr('disabled','');
		
		enableButton('ConnectButton');
	}
}


//ADVERTISEMENT CODE//////////////
//setAdvertisement('images/Advert.png','http://www.emotum.com');

// Checks the current status, and either displays an ad, or removes it if expire or
// dialler in wrong state.
function UpdateAdvertisment()
{
	if(mobileInfoState != MobileStateInternetConnected || wifiListExpanded)
	{
		return removeAdvertisement();
	}

	var newAdvertismentImageLocation = '';
	var newAdvertismentUrl = '';
	var newAdvertismentId = '';
	
	if(DEBUG_ShowAdvertisement) //DEBUG
	{
		currentAdvertisements = [{'Url':'http://www.emotum.com', 'ImageLocation':'images/Advert.png', 'IsLive':true}];
	}
	else if(CefRunning())
	{
		currentAdvertisements = cef.application.GetCurrentAdvertisments();
	}
	else
	{
		currentAdvertisements = [{'Url':'http://www.emotum.com', 'ImageLocation':'images/Advert.png', 'IsLive':true}];
	
		//newAdvertismentUrl = 'http://www.emotum.com';
		//newAdvertismentImageLocation = 'images/Advert.png';
	}
	
	if(currentAdvertisements == undefined || !currentAdvertisements.length)
		return removeAdvertisement();
	
	for(var i=0; i<currentAdvertisements.length; i++)
	{
		if(currentAdvertisements[i].IsLive)
		{
			newAdvertismentImageLocation = currentAdvertisements[i].ImageLocation;
			newAdvertismentUrl = currentAdvertisements[i].Url;
			newAdvertismentId = currentAdvertisements[i].Id;
			
			break;
		}
	}
	
	if(newAdvertismentImageLocation == undefined || newAdvertismentImageLocation == '')
		return removeAdvertisement();
	
	return setAdvertisement(newAdvertismentImageLocation, newAdvertismentUrl, newAdvertismentId);
}

function setAdvertisement(imageURL,URL, id)
{
	if(CefRunning())
		window.cefWindow.OutputDebugString('setAdvertisement - ' + imageURL + ' - ' + URL);

	if(currentAdvertismentUrl != imageURL)
	{
		//window.cefWindow.OutputDebugString('setAdvertisementAAA');
		$('#advert').css('background-image','url('+imageURL+')');
		$('#advert').removeClass('advertHidden');
		$('#advert').addClass('advertVisible');
	}	
	if(URL && URL != currentAdvertismentUrl)
	{
		//window.cefWindow.OutputDebugString('setAdvertisementBBB');
		$('#advert').css('cursor','pointer');
	}	
	
	currentAdvertismentImageUrl = imageURL;
	currentAdvertismentUrl = URL;
	currentAdvertismentId = id;
}

function removeAdvertisement()
{
	$('#advert').css('cursor','default');
	$('#advert').removeClass('advertVisible');
	$('#advert').addClass('advertHidden');
	
	currentAdvertismentUrl = '';
	currentAdvertismentImageUrl = '';	
	currentAdvertismentId = '';
}

function advertClicked()
{
	if(currentAdvertismentUrl)
	{
		launchURL(currentAdvertismentUrl);
		if(CefRunning())
			cef.application.SendAdvertismentLog({"Id":currentAdvertismentId, "Status":AdStateClicked});
	}
};
//END AVERTISEMENT CODE////////////////////////////

function setMainButtonStyle(buttonStyle){
		//Set the button colour style
		
		//Remove any existing styles.
		$('#ConnectButton').removeClass('MainButtonCONNECT');
		$('#ConnectButton').removeClass('MainButtonDISCONNECT');
		
		if(buttonStyle == 'Connect'){
			$('#ConnectButton').addClass('MainButtonCONNECT');
		}else if(buttonStyle == 'Disconnect'){
			$('#ConnectButton').addClass('MainButtonDISCONNECT');
		}

}
